IF  EXISTS(SELECT 1 FROM syscolumns WHERE ID = OBJECT_ID('PDV_VD_IT_REC') AND NAME = 'CD_REC')
BEGIN
	ALTER TABLE PDV_VD_IT_REC DROP PK_PDV_VD_IT_REC;
	ALTER TABLE PDV_VD_IT_REC DROP COLUMN CD_REC;
END;
GO
/*******************************************************************************************************************/
DECLARE @CD_EMP    INT
      , @CD_FILIAL INT
      , @CD_VD     INT
      , @CD_IT     INT;

DECLARE C_CHAVE CURSOR FAST_FORWARD
FOR SELECT
           CD_EMP
         , CD_FILIAL
         , CD_VD
         , CD_IT
    FROM
         PDV_VD_IT_REC
    GROUP BY
             CD_EMP
           , CD_FILIAL
           , CD_VD
           , CD_IT
    HAVING COUNT(*) > 1; 
OPEN c_Chave;

FETCH NEXT FROM c_Chave INTO @CD_EMP
                           , @CD_FILIAL
                           , @CD_VD
                           , @CD_IT;

WHILE @@FETCH_STATUS = 0
    BEGIN
        DELETE TOP (1)
        FROM PDV_VD_IT_REC
        WHERE
              CD_EMP = @CD_EMP
              AND CD_FILIAL = @CD_FILIAL
              AND CD_VD = @CD_VD
              AND CD_IT = @CD_IT;
        FETCH NEXT FROM c_Chave INTO @CD_EMP
                                   , @CD_FILIAL
                                   , @CD_VD
                                   , @CD_IT;
    END;

CLOSE c_Chave; 
DEALLOCATE c_Chave; 
GO 
/*******************************************************************************************************************/
IF NOT EXISTS(SELECT 1 FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS 
				WHERE CONSTRAINT_TYPE='PRIMARY KEY' and CONSTRAINT_NAME = 'PK_PDV_VD_IT_REC')
BEGIN
	ALTER TABLE PDV_VD_IT_REC ADD CONSTRAINT PK_PDV_VD_IT_REC PRIMARY KEY CLUSTERED 
	(
		CD_EMP ASC,
		CD_FILIAL ASC,
		CD_VD ASC, 
		CD_IT ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, 
						SORT_IN_TEMPDB = OFF, 
						IGNORE_DUP_KEY = OFF, 
						ONLINE = OFF, ALLOW_ROW_LOCKS = ON, 
						ALLOW_PAGE_LOCKS = ON) ON [PRIMARY];
END
/*******************************************************************************************************************/